@echo off
setlocal enabledelayedexpansion

:: Athenas Sync - Service Installation Script
:: Requires NSSM (Non-Sucking Service Manager)
:: Download NSSM from: https://nssm.cc/download

echo ============================================
echo   Athenas Sync - Instalador de Servico
echo ============================================
echo.

:: Check for admin rights
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo [ERRO] Este script precisa ser executado como Administrador!
    echo        Clique com botao direito e selecione "Executar como administrador"
    pause
    exit /b 1
)

:: Configuration
set SERVICE_NAME=AthenasSyncService
set SERVICE_DISPLAY_NAME=Athenas Sync Service
set SERVICE_DESCRIPTION=Servico de sincronizacao de arquivos XML com Athenas Online

:: Find NSSM
set NSSM_PATH=
if exist "%~dp0nssm.exe" (
    set NSSM_PATH=%~dp0nssm.exe
) else if exist "%~dp0..\nssm\nssm.exe" (
    set NSSM_PATH=%~dp0..\nssm\nssm.exe
) else if exist "%ProgramFiles%\nssm\nssm.exe" (
    set NSSM_PATH=%ProgramFiles%\nssm\nssm.exe
) else if exist "%ProgramFiles(x86)%\nssm\nssm.exe" (
    set NSSM_PATH=%ProgramFiles(x86)%\nssm\nssm.exe
) else (
    where nssm >nul 2>&1
    if !errorLevel! equ 0 (
        set NSSM_PATH=nssm
    )
)

if "!NSSM_PATH!"=="" (
    echo [ERRO] NSSM nao encontrado!
    echo.
    echo Por favor, baixe o NSSM de: https://nssm.cc/download
    echo E coloque o nssm.exe nesta pasta ou adicione ao PATH do sistema.
    echo.
    pause
    exit /b 1
)

echo [OK] NSSM encontrado: !NSSM_PATH!

:: Find Athenas Sync executable
set APP_PATH=
:: Check if running from installed location (scripts is inside resources)
if exist "%~dp0..\Athenas Sync.exe" (
    set "APP_PATH=%~dp0..\Athenas Sync.exe"
) else if exist "%~dp0..\..\Athenas Sync.exe" (
    set "APP_PATH=%~dp0..\..\Athenas Sync.exe"
) else if exist "%~dp0..\electron-build\win-unpacked\Athenas Sync.exe" (
    set "APP_PATH=%~dp0..\electron-build\win-unpacked\Athenas Sync.exe"
) else if exist "%ProgramFiles%\Athenas Sync\Athenas Sync.exe" (
    set "APP_PATH=%ProgramFiles%\Athenas Sync\Athenas Sync.exe"
) else if exist "%LocalAppData%\Programs\Athenas Sync\Athenas Sync.exe" (
    set "APP_PATH=%LocalAppData%\Programs\Athenas Sync\Athenas Sync.exe"
)

if "!APP_PATH!"=="" (
    echo [ERRO] Athenas Sync nao encontrado!
    echo.
    echo Certifique-se de que o aplicativo esta instalado ou foi feito o build.
    echo.
    pause
    exit /b 1
)

echo [OK] Athenas Sync encontrado: !APP_PATH!
echo.

:: Check if service already exists
"!NSSM_PATH!" status %SERVICE_NAME% >nul 2>&1
if %errorLevel% equ 0 (
    echo [AVISO] Servico ja existe. Removendo para reinstalar...
    "!NSSM_PATH!" stop %SERVICE_NAME% >nul 2>&1
    "!NSSM_PATH!" remove %SERVICE_NAME% confirm >nul 2>&1
    timeout /t 2 >nul
)

:: Install service
echo Instalando servico...
"!NSSM_PATH!" install %SERVICE_NAME% "!APP_PATH!"
if %errorLevel% neq 0 (
    echo [ERRO] Falha ao instalar o servico!
    pause
    exit /b 1
)

:: Configure service parameters
echo Configurando servico...
"!NSSM_PATH!" set %SERVICE_NAME% AppParameters --service
"!NSSM_PATH!" set %SERVICE_NAME% DisplayName "%SERVICE_DISPLAY_NAME%"
"!NSSM_PATH!" set %SERVICE_NAME% Description "%SERVICE_DESCRIPTION%"
"!NSSM_PATH!" set %SERVICE_NAME% Start SERVICE_AUTO_START
"!NSSM_PATH!" set %SERVICE_NAME% ObjectName LocalSystem

:: Configure stdout/stderr logging
set LOG_PATH=%USERPROFILE%\AppData\Local\athenas-sync\service-logs
if not exist "!LOG_PATH!" mkdir "!LOG_PATH!"
"!NSSM_PATH!" set %SERVICE_NAME% AppStdout "!LOG_PATH!\stdout.log"
"!NSSM_PATH!" set %SERVICE_NAME% AppStderr "!LOG_PATH!\stderr.log"
"!NSSM_PATH!" set %SERVICE_NAME% AppStdoutCreationDisposition 4
"!NSSM_PATH!" set %SERVICE_NAME% AppStderrCreationDisposition 4
"!NSSM_PATH!" set %SERVICE_NAME% AppRotateFiles 1
"!NSSM_PATH!" set %SERVICE_NAME% AppRotateBytes 1048576

echo [OK] Servico configurado!
echo.

:: Start service
echo Iniciando servico...
"!NSSM_PATH!" start %SERVICE_NAME%
if %errorLevel% neq 0 (
    echo [AVISO] Servico instalado mas nao foi possivel iniciar automaticamente.
    echo         Verifique se o aplicativo foi configurado corretamente primeiro.
) else (
    echo [OK] Servico iniciado com sucesso!
)

echo.
echo ============================================
echo   Instalacao concluida!
echo ============================================
echo.
echo Nome do servico: %SERVICE_NAME%
echo Logs em: !LOG_PATH!
echo.
echo Comandos uteis:
echo   - Verificar status: nssm status %SERVICE_NAME%
echo   - Parar servico:    nssm stop %SERVICE_NAME%
echo   - Iniciar servico:  nssm start %SERVICE_NAME%
echo   - Remover servico:  nssm remove %SERVICE_NAME%
echo.
echo IMPORTANTE: Certifique-se de que o aplicativo foi configurado
echo             (login e pasta de monitoramento) antes de usar como servico!
echo.
pause
