@echo off
setlocal enabledelayedexpansion

:: Athenas Sync - Service Uninstallation Script

echo ============================================
echo   Athenas Sync - Remover Servico
echo ============================================
echo.

:: Check for admin rights
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo [ERRO] Este script precisa ser executado como Administrador!
    echo        Clique com botao direito e selecione "Executar como administrador"
    pause
    exit /b 1
)

:: Configuration
set SERVICE_NAME=AthenasSyncService

:: Find NSSM
set NSSM_PATH=
if exist "%~dp0nssm.exe" (
    set NSSM_PATH=%~dp0nssm.exe
) else if exist "%~dp0..\nssm\nssm.exe" (
    set NSSM_PATH=%~dp0..\nssm\nssm.exe
) else if exist "%ProgramFiles%\nssm\nssm.exe" (
    set NSSM_PATH=%ProgramFiles%\nssm\nssm.exe
) else if exist "%ProgramFiles(x86)%\nssm\nssm.exe" (
    set NSSM_PATH=%ProgramFiles(x86)%\nssm\nssm.exe
) else (
    where nssm >nul 2>&1
    if !errorLevel! equ 0 (
        set NSSM_PATH=nssm
    )
)

if "!NSSM_PATH!"=="" (
    echo [ERRO] NSSM nao encontrado!
    echo.
    pause
    exit /b 1
)

echo [OK] NSSM encontrado: !NSSM_PATH!
echo.

:: Check if service exists
"!NSSM_PATH!" status %SERVICE_NAME% >nul 2>&1
if %errorLevel% neq 0 (
    echo [AVISO] Servico %SERVICE_NAME% nao encontrado.
    echo         Nada a remover.
    pause
    exit /b 0
)

:: Stop service first
echo Parando servico...
"!NSSM_PATH!" stop %SERVICE_NAME% >nul 2>&1
timeout /t 3 >nul

:: Remove service
echo Removendo servico...
"!NSSM_PATH!" remove %SERVICE_NAME% confirm
if %errorLevel% neq 0 (
    echo [ERRO] Falha ao remover o servico!
    pause
    exit /b 1
)

echo.
echo ============================================
echo   Servico removido com sucesso!
echo ============================================
echo.
echo O servico %SERVICE_NAME% foi desinstalado.
echo Os logs em %%USERPROFILE%%\AppData\Local\athenas-sync\service-logs
echo nao foram removidos. Delete manualmente se necessario.
echo.
pause
